<?php
//require 'vendor/autoload.php';
include 'vendor/autoload.php';

use Zxing\QrReader;

if (isset($_FILES['qr_image'])) {
    $imagePath = $_FILES['qr_image']['tmp_name'];

    // Read QR code from the uploaded image
    $qrcode = new QrReader($imagePath);
    $text = $qrcode->text(); // Decoded text

    echo "QR Code Data: " . htmlspecialchars($text);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>QR Code Scanner</title>
</head>
<body>
    <h2>Upload QR Code to Scan</h2>
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="qr_image" required>
        <button type="submit">Scan</button>
    </form>
</body>
</html>
